<html>
<! GetComponents.php                                          >
<! Appendix D, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script how to find installed extensions, interfaces   >
<! and classes.                                               >
<head>
<title>
  Appendix D : GetComponents.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.h {background-color: #9999cc; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Declare an array of environment classes.
  $extensions = get_loaded_extensions();

  // Sort by uppercase values.
  usort($extensions,'uppercase_sort');

  // Print the table with column labels.
  print to_table($extensions,'Declared Extensions');

  // Print break between tables.
  print "<p>";

  // Declare an array of environment interfaces.
  $interfaces = get_declared_interfaces();

  // Sort by uppercase values.
  usort($interfaces,'uppercase_sort');

  // Print the table with column labels.
  print to_table($interfaces,'Declared Interfaces');

  // Print break between tables.
  print "<p>";

  // Declare an array of environment classes.
  $classes = get_declared_classes();

  // Sort by uppercase values.
  usort($classes,'uppercase_sort');

  // Print the table with column labels.
  print to_table($classes,'Declared Classes');

  // Function renders three column table.
  function to_table($array_in,$title)
  {
    // Declare variable with table start.
    $output = "<table border=0 cellpadding=0 cellspacing=0>";
    $output .= "<tr>";
    $output .= "<td align=center class=h colspan=3 width=600>";
    $output .= $title;
    $output .= "</td>";
    $output .= "</tr>";

    // Check integer division by three and adjust for remainder.
    if ((count($array_in) % 3) == 0)
      $chunks = count($array_in) / 3;
    else
      $chunks = (int) (count($array_in) / 3) + 1;

    // Read and add array keys and values to a string.
    for ($i = 0;$i < $chunks;$i++)
    {
      // Append non-array value with cell tags.
      $output .= "<tr>";
      $output .= "<td class=v width=200>";
      $output .= "[".$array_in[$i]."]";
      $output .= "</td>";

      // Check if values exceed array elements and print placeholders.
      if (($i + $chunks) < count($array_in))
      {
        $output .= '<td width="225">';
        $output .= $array_in[$i+$chunks];
        $output .= '</td>';
      }
      else
        $output .= "<td width=225>&nbsp;</td>";

      // Check if values exceed array elements and print placeholders.
      if (($i + (2*$chunks)) < count($array_in))
      {
        $output .= "<td class=v width=200>";
        $output .= "[".$array_in[$i+(2*$chunks)]."]";
        $output .= "</td>";
      }
      else
        $output .= "<td class=v width=200>&nbsp;</td>";

      // Append row close.
      $output .= "</tr>";
    }

    // Close HTML table.
    $output .= "</table>";

    // Return the HTML table.
    return $output;
  }

  // Function to sort uppercase.
  function uppercase_sort($a,$b)
  {
    // Promote all keys to upper case.
    $a = strtoupper($a);
    $b = strtoupper($b);

    // Check which one is greater.
    return ($a > $b) ? 1 : -1;
  }
?>
</body>
</html>
