<html>
<! posix_get_group_info.php                                   >
<! Appendix E, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to get POSIX group info.      >
<head>
<title>
  Appendix E : posix_get_group_info.php
</title>
</head>
<body>
<?php
  // Check if command-line executed.
  if ($_SERVER['argc'] > 0)
    $script = true;
  else
    $script = false;

  // Print title.
  print "The result of <b>posix_getgrgid(posix_getuid()).</b><br />";

  // Secure information based on user identifier.
  foreach ($groupinfo = posix_getgrgid(posix_getgid()) as $name => $value)
    if ((is_array($value)) && (count($value) == 0))
      if ($script)
        print "[$name][Array()]\n";
      else
        print "[$name][Array()]<br />";
    else if ((is_array($value)) && (count($value) > 0))
      foreach ($value as $sname => $svalue)
        if ($script)
          print "[$name][$sname][$svalue]\n";
        else
          print "[$name][$sname][$svalue]<br />";
    else
      if ($script)
        print "[$name][$value]\n";
      else
        print "[$name][$value]<br />";

  // Print line break.
  print "<hr />";

  // Print title.
  print "The result of <b>posix_getgrnam(<i>group_name</i>).</b><br />";

  // Use the name to display information on user identifier.
  foreach (posix_getgrnam($groupinfo['name']) as $name => $value)
    if ((is_array($value)) && (count($value) == 0))
      if ($script)
        print "[$name][Array()]\n";
      else
        print "[$name][Array()]<br />";
    else if ((is_array($value)) && (count($value) > 0))
      foreach ($value as $sname => $svalue)
        if ($script)
          print "[$name][$sname][$svalue]\n";
        else
          print "[$name][$sname][$svalue]<br />";
    else
      if ($script)
        print "[$name][$value]\n";
      else
        print "[$name][$value]<br />";
?>
</body>
</html>
