<html>
<! Format_idate.php                                           >
<! Appendix F, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This demonstrates building a shorthand table of time       >
<! formatting attributes.                                     >
<head>
<title>
  Appendix F : Format_idate.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Declare an array of format characters and short defintions.
  $formats = array(array("B","Swatch Beat/Internet Time")
                  ,array("d","Day of the month")
                  ,array("h","Hour (12 hour format)")
                  ,array("H","Hour (24 hour format)")
                  ,array("i","Minutes")
                  ,array("I","1 if daylight savings enabled")
                  ,array("L","1 if leap year")
                  ,array("m","Month number")
                  ,array("s","Seconds")
                  ,array("t","Days in current month")
                  ,array("U","Seconds since Unix Epoch")
                  ,array("w","Day of the week")
                  ,array("W","ISO-8601 week number of year")
                  ,array("y","Year (1 or 2 digits)")
                  ,array("Y","Year (4 digits)")
                  ,array("z","Day of the year")
                  ,array("Z","Timezone offset in seconds"));

  // Print HTML table and column headers.
  print '<table border="1" cellpadding="3" cellspacing="0">';
  print '<tr>';
  print '<td colspan="3" align="center" class="e">';
  print 'Today ['.date("d M y").']';
  print '</td>';
  print '</tr>';
  print '<tr>';
  print '<td class="e">Format</td>';
  print '<td class="e">Definition</td>';
  print '<td class="e">Value</td>';
  print '</tr>';

  // Print array contents into HTML table.
  for ($i = 0;$i < count($formats);$i++)
  {
    print '<tr>';
    print '<td class="v">'.$formats[$i][0].'</td>';
    print '<td class="v">'.$formats[$i][1].'</td>';
    print '<td class="v">'.idate($formats[$i][0]).'</td>';
    print '</tr>';
  }

  // Print HTML table close.
  print '</table>';
?>
</body>
</html>
