-- select_item_records.sql
-- Appendix H, Oracle Database XE PHP Web Programming
-- by Michael McLaughlin
--
-- This script demonstrates how to query data from two tables
-- using an ANSI SQL:2003 inner join with column and table aliases.


SPOOL select_item_records.log

SET ECHO ON
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

SELECT   i.item_id AS id
,        i.item_barcode AS barcode
,        c.common_lookup_type AS type
,        i.item_title AS title
,        i.item_rating AS rating
,        i.item_release_date AS release_date
FROM     item i INNER JOIN common_lookup c
ON       i.item_type = c.common_lookup_id
WHERE    c.common_lookup_type = 'XBOX'
ORDER BY i.item_title;

SPOOL OFF