-- update_member_record.sql
-- Appendix H, Oracle Database XE PHP Web Programming
-- by Michael McLaughlin
--
-- This script demonstrates how to update a single column of the
-- CONTACT table using a correlated query.


SPOOL update_member_record.log

SET ECHO ON
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

UPDATE   contact c1
SET      c1.middle_initial = 'B'
WHERE    EXISTS (SELECT   NULL
                 FROM     contact c2
                 WHERE    c1.contact_id = c2.contact_id
                 AND      c2.last_name = 'Vizquel'
                 AND      c2.first_name = 'Oscar');

SPOOL OFF