/*
 * exception.sql
 * Appendix I, Oracle Database XE PHP Web Programming
 * by Michael McLaughlin
 *
 * This script demonstrates a error management when a string larger
 * than 10 characters is provided as the substitution parameter.
 */

-- Unremark for debugging script.
SET PAGESIZE 999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  my_var VARCHAR2(10);

BEGIN

  my_var := '&input';

  dbms_output.put_line('Hello '|| my_var );

EXCEPTION

  WHEN others THEN
    dbms_output.put_line(SQLERRM);
    RETURN;

END;
/
