/*
 * ifthen.sql
 * Appendix I, Oracle Database XE PHP Web Programming
 * by Michael McLaughlin
 *
 * This script demonstrate the behavior of a non-initialized Boolean
 * variable.
 */

-- Unremark for debugging script.
SET PAGESIZE 999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Define a Boolean variable.
  my_var BOOLEAN;

BEGIN

  -- Use a NVL function to substitute a value for evalution.
  IF NOT NVL(my_var,false) THEN
    dbms_output.put_line('This should happen!');
  ELSE
    dbms_output.put_line('This can''t happen!');
  END IF;

END;
/
