<html>
<! DiskSystem.php                                             >
<! Chapter 10, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to verify whether strings map >
<! to directories, files or files with specific behaviors.    >
<head>
<title>
  Chapter 10 : DiskSystem.php
</title>
</head>
<body>
<?php
  // Get the mount point free disk space.
  $free = number_format(disk_free_space(getcwd())/1073741824,2);

  // Get the mount point total disk space.
  $available = number_format(disk_total_space(getcwd())/1073741824,2);

  // Get percentage free space.
  $percentage = substr(($free/$available*100),0,4);

  // Build an associative array to print in HTML table.
  $display = array();
  $display['Free Disk Space'] = substr($free,0,4)." GB";
  $display['Available Disk Space'] = substr($available,0,4)." GB";
  $display['Percentage Free Disk Space'] = $percentage."%";

  // Open HTML table.
  print "<table border=0 cellpadding=0 cellspacing=0>";

  // Read and add array keys and values to a string.
  foreach ($display as $name => $value)
  {
    // Prepend row tag and first column value.
    print "<tr><td valign=top>[".$name."]</td>";

    // Append row tag and second column value.
    print "<td>[".$value."]</td></tr>";
  }

  // Close HTML table.
  print "</table>";
?>
</body>
</html>