<html>
<! Glob.php                                                   >
<! Chapter 10, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to search for files matching  >
<! wildcard characteristics, and returns a list of files.     >
<head>
<title>
  Chapter 10 : Glob.php
</title>
</head>
<body>
<?php
  // Declare a file root.
  $file = "NewFile";

  // Declare file variables.
  $file1 = $file."1.txt";
  $file2 = $file."2.txt";

  // Check for file before creating it.
  if (!file_exists($file1))
    touch($file1);

  // Print matching files from directory.
  print "<hr />".find_files($file."*.txt");

  // Copy first file to second file.
  copy($file1,$file2);

  // Print matching files from directory.
  print "<hr />".find_files($file."*.txt");

  // Delete first file from directory.
  unlink($file1);

  // Print matching files from directory.
  print "<hr />".find_files($file."*.txt")."<hr />";

  // Find a list of files in a directory passed by reference.
  function find_files($search_string)
  {
    // Declare a return string.
    $list = "";

	// Declare an array with the wildcard matching files.
    $dir = glob($search_string);

    // Read through the list of files.
    for ($i = 0;$i < count($dir);$i++)
        $list .= $dir[$i]."<br />";

	// Return the formatted string.
	return $list;
  }
?>
</body>
</html>