<html>
<! IdentifyFiles.php                                          >
<! Chapter 10, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates a how to read file statistics and >
<! format UID, GID and date values.                           >
<head>
<title>
  Chapter 10 : IdentifyFiles.php
</title>
</head>
<body>
<?php
  // Read the parameter from the URL.
  $file = $_GET["p_name"];

  // Verify the file exists.
  if (file_exists($file))
  {
    // Assign statistics to a local variable.
    $info = stat($file);

    // Declare variable with table start.
    $out = "<table border=0 cellpadding=0 cellspacing=0>";

    // Read the statistics on the file.
    foreach ($info as $name => $value)
    {
      // Eliminate numerically index row set.
      if (!ereg("[0-9]",$name))
      {
        // Append row tags and column values.
        $out .= "<tr><td valign=top>[".$name."]</td>";

		// Leverage fall through and simplify logic.
        switch (true)
        {
          case ($name == "atime"):
          case ($name == "mtime"):
          case ($name == "ctime"):
		    // Convert the integer value to a meaningful date.
            $out .= "<td>[".date('d-M-Y h:i:s',$value)."]</td></td>";
            break;
          case ($name == "gid"):
          case ($name == "uid"):
            // POSIX library coverts the number.
            if ((!ereg("Win32",$_SERVER["SERVER_SOFTWARE"])) &&
                (array_search("posix",get_loaded_extensions())))
			{
              $user_name = posix_getpwuid($value);
              $out .= "<td>[".$user_name['name']."]</td></tr>";
			}
			else
			  $out .= "<td>[".$value."]</td></tr>";
            break;
          default:
            $out .= "<td>[".$value."]</td></tr>";
        }
      }
    }

    // Close HTML table.
    $out .= "</table>";

    // Print file statistics.
    print $out;
  }
?>
</body>
</html>
