<html>
<! MoveFile.php                                               >
<! Chapter 10, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This demonstrates how to move a file by copying and then   >
<! deleting the file; and managing a directory handle.        >
<head>
<title>
  Chapter 10 : MoveFile.php
</title>
</head>
<body>
<?php
  // Declare file variables.
  $file1 = "NewFile1.txt";
  $file2 = "NewFile2.txt";

  // Declare array of files.
  $list = array($file1,$file2);
  
  // Check for file before creating it.
  if (!file_exists($file1))
    touch($file1);

  // Secure a directory handle.
  $dhandle = opendir(getcwd());  
    
  // Print matching files from directory.
  print "<hr />".find_files($list,$dhandle);

  // Copy first file to second file.
  copy($file1,$file2);

  // Print matching files from directory.
  print "<hr />".find_files($list,$dhandle);

  // Delete first file from directory.
  unlink($file1);

  // Print matching files from directory.
  print "<hr />".find_files($list,$dhandle)."<hr />";

  // Close directory handle.
  @closedir($dhandle);
 
  // Find a list of files in a directory passed by reference.
  function find_files($set,&$dhandle)
  {
    // Declare a return string.
    $list = "";

    // Read through the list of files.	
    while (($file = readdir($dhandle)) !== false)
    {
	  // Check if they're members of the search array.
      if (in_array($file,$set))
        $list .= $file."<br />";
    }
	
	// Rewind the directory handle so that it can be reused.
    rewinddir($dhandle);
	
	// Return the formatted string.
	return $list;
  }
?>
</body>
</html>