<html>
<! BasicAuthentication.inc                                    >
<! Chapter 11, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This defines Basic HTTP Authentication library for user    >
<! maintenance forms.                                         >
<head>
<title>
  Chapter 11 : BasicAuthentication.inc
</title>
</head>
<body>
<?php

  /* Library functions.
  || ----------------------------------------------------------------
  ||  Function Name               Return Type  Parameters
  || ---------------------------  -----------  ----------------------
  ||  authenticate()              void
  ||  get_message()               string       int      $code
  ||                                           string   $userid
  ||  write_string()              void         resource $file
  ||                                           string   $string
  ||  verify_authentication()     bool
  ||  verify_user()               bool         string   $userid
  ||  verify_valid_credentials()  int          string   $userid
  ||                                           string   $passwd
  */


  // Force basic HTTP authentication.
  function authenticate()
  {
    // Send headers to force basic HTTP authentication.
    header('WWW-Authenticate: Basic Realm="www.techtinker.com"');
    header('HTTP/1.0 401 Unauthorized');
  
    // Print failed validation message.
    print "<html><body><font size=+2>";
    print "The site has logged your [".$_SERVER['REMOTE_ADDR']."] IP ";
    print "address, please enter a valid user and password.";
    print "</font></body></html>";
  }

  // Build entry form.
  function get_message($code,$userid)
  {
    // Designate message by error code.
    switch ($code)
    {
      case 0:
        return "You have added user [$userid] successfully.";
      case 1:
        return "User [$userid] is already in use.";
      case 2:
        return "User [$userid] must start with a character.";
      case 3:
        return "User [$userid] must be between 6 and 10 characters.";
      case 4:
        return "The password must be between 6 and 10 characters.";
    }
  }
  
  // Define a Basic Authentication function.
  function verify_authentication()
  {
    // Check for HTTP basic authentication variables.  
    if ((isset($_SERVER['PHP_AUTH_USER'])) &&
        (isset($_SERVER['PHP_AUTH_PW'])))
    {
      // Read the file into an array of strings.
      $passwords = file("simplepassword.txt");
    
      // Read through the value list.    
      foreach ($passwords as $credentials)
      {
        // Break the delimited lines into scalar variables.
        list($username,$password) = explode(":",$credentials);
      
        // Find a match and return valid credentials.
        if (($_SERVER['PHP_AUTH_USER'] == $username) &&
            (md5($_SERVER['PHP_AUTH_PW']) == trim($password)))
          return true;
      }
    }
  
  // Return invalid credentials.
  return false;
  }

  // Check for existing user.
  function verify_user($userid)
  {
    // Read the file into an array of strings.
    $passwords = file("simplepassword.txt");

    // Read through the value list.
    foreach ($passwords as $credentials)
    {
      // Break the delimited lines into scalar variables.
      list($username,$password) = explode(":",$credentials);

      // Return there is a user.
      if ($userid == $username)
        return true;
    }

    // Return there is no existing user.
    return false;
  }

  // Check user name and password meet rules.
  function verify_valid_credentials($userid,$passwd)
  {
    switch(true)
    {
      // Ensure user name doesn't already exist.
      case (verify_user($userid)):
        return 1;

      // Verify user name starts with a alphabetic characters.
      case (!ereg("([a-zA-Z]+[a-zA-Z0-9]{0,1})",substr($userid,0,1))):
        return 2;

      // Verify user name is 6 to 10 alpha-numeric characters with a letter first.
      case (!ereg("([a-zA-Z]+[a-zA-Z0-9]{5,10})",$userid)):
        return 3;
    
      // Verify password is 6 to 10 alpha-numeric characters with a letter first.
      case (!ereg("([a-zA-Z0-9]{5,10})",$passwd)):
        return 4;

      // Acknowledge everything is fine.    
      default:
      return 0;
    }
  }

    // Define function to write a colon delimited file.
  function write_string($file,$string)
  {
    // Declare an write file resource.
    if ($fp = fopen($file,'a+'))
    {
      // Read the two-dimensional array and write or append to a file.
      fwrite($fp,"\n".$string);

      // Close the open file handle.
      fclose($fp);
    }
  }
?>
</body>
</html>
