<html>
<! BindFetchArraySQL.php                                      >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to return rows of data with a >
<! single oci_fetch_all() call.                               >
<head>
<title>
  Chapter 13: BindFetchArraySQL.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php", "php", "xe"))
  {
    // Declare input variables.
    (isset($_GET['limit']))   ? $limit = (int) $_GET['limit']
                              : $limit = 5;
    (isset($_GET['param']))   ? $flag = (int) $_GET['param']
                              : $flag = 0;


    // Parse a query to a resource statement.
    $s = oci_parse($c,"SELECT   cr.full_name
                       ,        cr.title
                       ,        cr.subtitle
                       ,        cr.product
                       ,        cr.check_out_date
                       ,        cr.return_date
                       FROM     current_rental cr
                       ,       (SELECT   cr.account_number
                                FROM     current_rental cr
                                GROUP BY cr.account_number
                                HAVING   COUNT(account_number) >= :limit) l
                       WHERE    cr.account_number = l.account_number");

    // Bind a variable into the resource statement.
    oci_bind_by_name($s,":limit",$limit);

    // Execute the parsed query without a commit.
    oci_execute($s,OCI_DEFAULT);

    // Declare counter.
    $counter = 1;

    // Set oci_fetch_array() mode value.
    switch ($flag)
    {
      case 0:
        print "here";
        $flag_value = OCI_BOTH;
        break;
      case 1:
        $flag_value = OCI_BOTH|OCI_RETURN_NULLS;
        break;
      case 2:
        $flag_value = OCI_BOTH|OCI_RETURN_NULLS|OCI_RETURN_LOBS;
        break;
      case 3:
        $flag_value = OCI_ASSOC;
        break;
      case 4:
        $flag_value = OCI_ASSOC|OCI_RETURN_NULLS;
        break;
      case 5:
        $flag_value = OCI_ASSOC|OCI_RETURN_NULLS|OCI_RETURN_LOBS;
        break;
      case 6:
        $flag_value = OCI_NUM;
        break;
      case 7:
        $flag_value = OCI_NUM|OCI_RETURN_NULLS;
        break;
      case 8:
        $flag_value = OCI_NUM|OCI_RETURN_NULLS|OCI_RETURN_LOBS;
        break;
      default:
        $flag_value = OCI_BOTH;
        break;
     }

    // Print open HTML table tag.
    print '<table border="1" cellspacing="0" cellpadding="3">';

    // Read and print statement row return.
    while ($array_out = oci_fetch_array($s,$flag_value))
    {
      // Print row counter.
      print '<tr>';
      print '<td align="center" class="e" colspan="2">';
      print 'Row #'.$counter++;
      print '</td></tr>';

      // Read through the first dimension of the record set.
      foreach ($array_out as $name => $value)
      {
        print '<tr>';
        print '<td class="e">'.$name.'</td>';
        if (is_null($value))
          print '<td class="v">&nbsp;</td>';
        else
          print '<td class="v">'.$value.'</td>';
        print '</tr>';
      }
    }

    // Print the close HTML table tag.
    print '</table>';

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
