<html>
<! BindFetchObjectSQL.php                                     >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to return rows of data with a >
<! single oci_fetch_object() call.                            >
<head>
<title>
  Chapter 13: BindFetchObjectSQL.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php", "php", "xe"))
  {
    // Declare input variables.
    (isset($_GET['limit']))   ? $limit = (int) $_GET['limit']
                              : $limit = 5;

    // Parse a query to a resource statement.
    $s = oci_parse($c,"SELECT   cr.full_name
                       ,        cr.title
                       ,        cr.product
                       ,        cr.check_out_date
                       ,        cr.return_date
                       FROM     current_rental cr
                       ,       (SELECT   cr.account_number
                                FROM     current_rental cr
                                GROUP BY cr.account_number
                                HAVING   COUNT(account_number) >= :limit) l
                       WHERE    cr.account_number = l.account_number");

    // Bind a variable into the resource statement.
    oci_bind_by_name($s,":limit",$limit);

    // Execute the parsed query without a commit.
    oci_execute($s,OCI_DEFAULT);

    // Print open HTML table tag.
    print '<table border="1" cellspacing="0" cellpadding="3">';

    // Read and print statement row return.
    $object_out = oci_fetch_object($s);

    // Read through the first dimension of the record set.
    for ($i = 1;$i <= oci_num_fields($s);$i++)
    {
      $name = oci_field_name($s,$i);
     print '<tr>';
      print '<td class="v">'.$name.'</td>';
      if (oci_field_is_null($s,$i))
        print '<td class="v">&nbsp;</td>';
      else
        print '<td class="v">'.$object_out->$name.'</td>';
      print '</tr>';
    }

    // Print the close HTML table tag.
    print '</table>';

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
