<html>
<! BindFetchSQL.php                                           >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to return rows of data by     >
<! specific column names.                                     >
<head>
<title>
  Chapter 13: BindFetchSQL.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Declare input variables.
    (isset($_GET['lname'])) ? $lname = $_GET['lname']
                            : $lname = "[a-zA-Z]";

    // Declare array mapping column to display names.
    $q_title = array("FULL_NAME"=>"Full Name"
                    ,"TITLE"=>"Title"
                    ,"CHECK_OUT_DATE"=>"Check Out"
                    ,"RETURN_DATE"=>"Return");

    // Parse a query to a resource statement.
    $s = oci_parse($c,"SELECT   cr.full_name
                       ,        cr.title
                       ,        cr.check_out_date
                       ,        cr.return_date
                       FROM     current_rental cr
                       WHERE    REGEXP_LIKE(cr.full_name,:lname)");

    // Bind a variable into the resource statement.
    oci_bind_by_name($s,":lname",$lname,-1,SQLT_CHR);

    // Execute the parsed query without a commit.
    oci_execute($s,OCI_DEFAULT);

    // Print the table header using calls to the query metadata.
    print '<table border="1" cellspacing="0" cellpadding="3">';

    // Print a open and close HTML row tags and column field names.
    print '<tr>';
    for ($i = 1;$i <= oci_num_fields($s);$i++)
      print '<td class="e">'.$q_title[oci_field_name($s,$i)].'</td>';
    print "</tr>";

    // Read and print statement row return.
    while (oci_fetch($s))
    {
      // Print open and close HTML row tags and columns data.
    print '<tr>';
      for ($i = 1;$i <= oci_num_fields($s);$i++)
        print '<td class="v">'.oci_result($s,$i).'</td>';
      print '</tr>';
    }

    // Print a close HTML table tag.
    print '</table>';

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
