<html>
<! InsertTransaction.php                                      >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to insert a row of data by    >
<! specific column names using a bind variable in the         >
<! subquery where clause.                                     >
<head>
<title>
  Chapter 13: InsertTransaction.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Declare an array in lieu of $_POST for entry.
    $account_number = "B303-73740";
    $credit_card_no = "5555-5555-5555-5555";
    $credit_card_type = "DISCOVER_CARD";

    // Parse an insert into a resource statement.
    $s = oci_parse($c,"INSERT INTO member VALUES
                       ( member_s1.nextval
                       , :account_no
                       , :credit_card_no
                       ,(SELECT   common_lookup_id
                         FROM     common_lookup
                         WHERE    common_lookup_context = 'MEMBER'
                         AND      common_lookup_type = :credit_card_type)
                       , 3, SYSDATE, 3, SYSDATE )");

    // Bind a variable into the resource statement.
    oci_bind_by_name($s,":account_no",$account_number,-1,SQLT_CHR);
    oci_bind_by_name($s,":credit_card_no",$credit_card_no,-1,SQLT_CHR);
    oci_bind_by_name($s,":credit_card_type",$credit_card_type,-1,SQLT_CHR);

    // Execute the parsed query without a commit.
    oci_execute($s,OCI_DEFAULT);

    // Commit transaction.
    oci_commit($c);

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
