<html>
<! OraclePersistentConnection.php                             >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! The script test a standard and new persistent connection   >
<! to an Oracle database and requires you to have installed   >
<! Zend Core. You should run create_signon_triggers.sql prior >
<! to running this program. The login and logout script       >
<! triggers capture connections by building a table, a        >
<! package with two procedures, and two database triggers.    >
<head>
<title>
  Chapter 13: OraclePersistentConnection.php
</title>
</head>
<body>
<?php
  // Attempt to connect with user schema and password, then TNS alias.
  if ($c = @oci_pconnect("php","php","xe"))
  {
    // Set session tracking variables.
    $session_name_in = "Session at [".date('d-M-y H:i:s')."]";
    $session_name_out = "";

    // Declare statement strings.
    $stmt1 = "BEGIN session_manager.get_session(:s_name); END;";
    $stmt2 = "BEGIN session_manager.set_session(:s_name); END;";

    // Parse statement strings.
    $s1 = oci_parse($c,$stmt1);
    $s2 = oci_parse($c,$stmt2);

    // Bind IN/OUT mode variable to $s1 and IN only mode variable to $s2.
    oci_bind_by_name($s1,":s_name",$session_name_out,64,SQLT_CHR);
    oci_bind_by_name($s2,":s_name",$session_name_in,64,SQLT_CHR);

    // Run GET_SESSION procedure.
    oci_execute($s1);

    // Read result from GET_SESSION procedure.
    if (is_null($session_name_out))
    {
      // Run SET_SESSION procedure and rerun GET_SESSION procedure.
      oci_execute($s2);

      // Print successful message.
      print "Successfully created a persistent Oracle connection.<br />";
      print "Set [$session_name_in]<br>";
    }
    else
    {
      // Print successful message.
      print "Reconnected to a persistent Oracle connection.<br />";
      print "Get [$session_name_out]<br>";
    }
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
  }
?>
</body>
</html>
