<html>
<! SelectItemRecords.php                                      >
<! Chapter 13, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to return rows of data by     >
<! using a hard-coded query against specific column names.    >
<head>
<title>
  Chapter 13: SelectItemRecords.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Connect to the database.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Parse a query to a resource statement.
    $s = oci_parse($c,"SELECT   i.item_id id
                       ,        i.item_barcode as barcode
                       ,        c.common_lookup_type as type
                       ,        i.item_title as title
                       ,        i.item_rating as rating
                       ,        i.item_release_date release_date
                       FROM     item i inner join common_lookup c
                       ON       i.item_type = c.common_lookup_id
                       WHERE    c.common_lookup_type = 'XBOX'
                       ORDER BY i.item_title");

    // Execute query without an implicit commit.
    oci_execute($s,OCI_DEFAULT);

    // Open the HTML table.
    print '<table border="1" cellspacing="0" cellpadding="3">';

    // Read fetched headers.
    print '<tr>';
    for ($i = 1;$i <= oci_num_fields($s);$i++)
      print '<td class="e">'.oci_field_name($s,$i).'</td>';
    print '</tr>';

    // Read fetched data.
    while (oci_fetch($s))
    {
      // Print open and close HTML row tags and columns data.
      print '<tr>';
      for ($i = 1;$i <= oci_num_fields($s);$i++)
        print '<td class="v">'.oci_result($s,$i).'</td>';
      print '</tr>';
    }

    // Close the HTML table.
    print '</table>';

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
