-- get_connection_results.sql
-- Chapter 13, Oracle Database XE PHP Web Programming
-- by Michael McLaughlin
--
-- This query gets the posted connections to the database inserted by the
-- login and logout triggers.

SPOOL get_connection_results.log

-- SET ECHO ON
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

COL event_user_name FORMAT A20

SELECT   event_id
,        event_user_name
,        event_type
,        TO_CHAR(event_date,'DD-MON-YYYY HH24:MI:SS') time
FROM     system.connection_log;

SPOOL OFF