-- get_session_logs.sql
-- Chapter 13, Oracle Database XE PHP Web Programming
-- by Michael McLaughlin
--
-- This query displays session logins and logouts.

COL session_id       FORMAT 999 HEADING "#"
COL session_activity FORMAT A3 HEADING "Act"
COL session_name     FORMAT A32 HEADING "Session Name"
COL connection       FORMAT A20 HEADING "Connection|Date Stamp"

SELECT   session_id
,        session_activity
,        session_name
,        TO_CHAR(session_date,'DD-MON-YYYY HH24:MI:SS') connection
FROM     session_log
/
