<html>
<! AppendAssign.php                                           >
<! Chapter 14, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This demonstrates how to return a set of data rows then    >
<! copy the set from one bound collection to another before   >
<! updating an intentionally removed element.                 >
<head>
<title>
  Chapter 14: AppendAssign.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Declare array.
    $president_array = array("George Washington","John Adams"
                            ,"Thomas Jefferson","James Madison"
                            ,"James Monroe","John Quincy Adams"
                            ,"Andrew Jackson","Martin Van Buren"
                            ,"William Henry Harrison","John Tyler"
                            ,"James Polk","Zachary Taylor"
                            ,"","Franklin Pierce"
                            ,"James Buchanan","Abraham Lincoln");

    // Declare a variable containing the missing president.
    $unlucky_number = "Millard Fillmore";

    // Define NESTED TABLE OCI-Collection types.
    $president_master = oci_new_collection($c,'PRESIDENT_NAME_NTABLE');
    $president_copy = oci_new_collection($c,'PRESIDENT_NAME_NTABLE');


    // Read the array contents and add them to OCI-Collection.
    for ($i = 0;$i < count($president_array);$i++)
      if ($president_master->append($president_array[$i]));

    // Assign the original master to a copy.
    $president_copy->assign($president_master);

    // Declare variable, open HTML table and write headers.
    $out  = '<table border="1" cellpadding="3" cellspacing="0">';
    $out .= '<tr>';
    $out .= '<td align="center" colspan="2" class="e">Master</td>';
    $out .= '<td align="center" colspan="2" class="e">Copy</td>';
    $out .= '</tr>';
    $out .= '<tr>';
    $out .= '<td class="e">#</td>';
    $out .= '<td class="e">President Name</td>';
    $out .= '<td class="e">#</td>';
    $out .= '<td class="e">President Name</td>';
    $out .= '</tr>';

    // Read collections.
    for ($j = 0;$j < $president_master->size();$j++)
    {
      // Open row and 1 to index.
      $out .= '<tr>';
      $out .= '<td class="v">'.($j + 1).'</td>';

      // Check for missing president in OCI-Collection master.
      if (!is_null($value = $president_master->getElem($j)))
        $out .= '<td class="v">'.$value.'</td>';
      else
      {
        $president_master->assignElem($j,$unlucky_number);
        $out .= '<td class="v">';
        $out .= $president_master->getElem($j);
        $out .= '</td>';
      }

      // Add 1 to index.
      $out .= '<td class="v">'.($j + 1).'</td>';

      // Check for missing president in OCI-Collection copy.
      if (!is_null($value = $president_copy->getElem($j)))
        $out .= '<td class="v">'.$value.'</td>';
      else
        $out .= '<td class="v">&nbsp;</td>';

      // Close row.
      $out .= '</tr>';
    }

    // Close HTML table.
    $out .= '</table>';

    // Print the HTML table.
    print $out;

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
