<html>
<! QueryLobSQL.php                                            >
<! Chapter 15, Oracle Database XE PHP Web Programming         >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to return a CLOB or BLOB via  >
<! a SQL SELECT statement.                                    >
<head>
<title>
  Chapter 15: QueryLobSQL.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Return successful attempt to connect to the database.
  if ($c = @oci_connect("php","php","xe"))
  {
    // Declare input variables.
    (isset($_GET['id'])) ? $id = (int) $_GET['id'] : $id = 1;
    (isset($_GET['name'])) ? $name = $_GET['name'] : $name = "Washington";

    // Declare a SQL SELECT statement returning a CLOB.
    $stmt = "SELECT   biography
             FROM     president
             WHERE    president_id = :id";

    // Parse a query through the connection.
    $s = oci_parse($c,$stmt);

    // Bind PHP to OCI variable(s).
    oci_bind_by_name($s,':id',$id);

    // Execute the PL/SQL statement.
    if (oci_execute($s))
    {
      // Return a LOB descriptor as the value.
      while (oci_fetch($s))
      {
        for ($i = 1;$i <= oci_num_fields($s);$i++)
          if (is_object(oci_result($s,$i)))
          {
            if ($size = oci_result($s,$i)->size())
              $data = oci_result($s,$i)->read($size);
            else
              $data = "&nbsp;";
          }
          else
          {
            if (oci_field_is_null($s,$i))
              $data = "&nbsp;";
            else
              $data = oci_result($s,$i);
          }
      } // End of the while(oci_fetch($s)) loop.

      // Format HTML table to display biography.
      $out = '<table border="1" cellpadding="3" cellspacing="0">';
      $out .= '<tr>';
      $out .= '<td align="center" class="e">Biography of '.$name.'</td>';
      $out .= '</tr>';
      $out .= '<tr>';
      $out .= '<td class="v">'.$data.'</td>';
      $out .= '</tr>';
      $out .= '</table>';

    }

    // Print the HTML table.
    print $out;

    // Disconnect from database.
    oci_close($c);
  }
  else
  {
    // Assign the OCI error and format double and single quotes.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>
</body>
</html>
