<html>
<! GetConstants.php                                           >
<! Chapter 4, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to find and display your      >
<! environment constants.                                     >
<head>
<title>
  Chapter 4 : GetConstants.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.h {background-color: #9999cc; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Declare an array of environment constants.
  $constants = get_defined_constants();

  // Sort by promoting the keys to upper case.
  uksort($constants,'uppercase_sort');

  // Print the table with column labels.
  print to_table($constants,'Constant Names','Constant Values');

  // ------------------------------------------------------------

  // A function to render a tables.
  function to_table($array_in,$column_1,$column_2)
  {
    // Declare variable with table start.
    $output = "<table border=0 cellpadding=0 cellspacing=0>";
    $output .= "<tr><td class=h>".$column_1."</td>";
    $output .= "<td class=h>".$column_2."</td></tr>";

    // Read and add array keys and values to a string.
    foreach ($array_in as $hashName => $hashValue)
    {
      // Append row tag and first column value.
      $output .= "<tr><td class=e valign=top>[".$hashName."]</td>";

        // Append non-array value with cell tags.
        $output .= "<td class=v>[".$hashValue."]</td></tr>";
    }

    // Close HTML table.
    $output .= "</table>";

    // Return the HTML table.
    return $output;
  }

  // ------------------------------------------------------------

  // Define a comparison function.
  function uppercase_sort($a,$b)
  {
    // Promote all keys to upper case.
    $a = strtoupper($a);
    $b = strtoupper($b);

    // Check if one is greater than the other.
    return ($a > $b) ? 1 : -1;
  }
?>
</body>
</html>
