<html>
<! Usort.php                                                  >
<! Chapter 6, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script declares a user-defined sort operation, a      >
<! local array and uses the user-defined sort to sort string  >
<! dates as they are typically returned from an Oracle        >
<! database.                                                  >
<head>
<title>
  Chapter 6 : Usort.php
</title>
</head>
<body>
<?php
  // Define a comparison function.
  function calendarSort($a,$b)
  {
    // Build key to value map for calendar months.
    $month = array("JAN","FEB","MAR","APR","MAY","JUN"
                  ,"JUL","AUG","SEP","OCT","NOV","DEC");

    // Check if equal.
    if ($a == $b) return 0;

    // Divide Oracle default date string into component values.
    list($day1,$month1,$year1) = explode("-",$a);
    list($day2,$month2,$year2) = explode("-",$b);

    // Create numeric dates in a YYM[M]D[D] format mask.
    $a = $year1.array_search($month1,$month).$day1;
    $b = $year2.array_search($month2,$month).$day2;

    // Check if one is greater than the other.
    return ($a > $b) ? 1 : -1;
  }

  // Declare array variable.
  $salutation = array("10-JAN-06","14-JUL-06","01-MAY-06");

  // Print structured ordering.
  print "[".print_r($salutation,true)."].<br>";

  // Perform a custom sort operation.
  usort($salutation,'calendarSort');

  // Print restructured ordering.
  print "[".print_r($salutation,true)."].<br>";
?>
</body>
</html>
