<html>
<! Abstract.php                                               >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script declares and instantiate an abstract object    >
<! type and a subclass that implements the object type.       >
<head>
<title>
  Chapter 8 : Abstract.php
</title>
</head>
<body>
<?php
  // Declare a instance of the concrete class.
  $myObject = new PageHeader();

  // Call the concrete class instance.
  $myObject->writePage("Concrete Class!");

  // Define an abstract class.
  abstract class PageWriter
  {
    // Define an abstract function specification.
    abstract function writePage($var);

    // Define a function
    protected function getClassName()
    {
      // Return class name.
      return __CLASS__;
    }
  }

  // Define a concrete class.
  class PageHeader extends PageWriter
  {
    // Provide implementation of the abstract function.
    public function writePage($var)
    {
      // Print local class name and actual parameter.
      print "[".__CLASS__."] [".$var."]<br>";

      // Print parent class name and actual parameter.
      print "[".parent::getClassName()."] [Abstract Class!]<br>";
    }
  }
?>
</body>
</html>
