<html>
<! Address.inc                                                >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script defines and implements an Address class or     >
<! object type as an included (.inc) library.                 >
<head>
<title>
  Chapter 8 : Address.inc
</title>
</head>
<body>
<?php
  // Define a class.
  class Address
  {
    // Declare instance counter.
    public static $instances = 0;

    // Declare instance number.
    private $instance;

    // Define instance variables.
    private $first_name = "";
    private $last_name = "";
    private $street_address = "";
    private $city = "";
    private $state = "";
    private $zip = "";

    // Define overriding constructor.
    public function __construct($first_name,$last_name
                               ,$street_address
                               ,$city,$state,$zip)
    {
      // Set the instance counter and number instance.
      $this->instance = ++self::$instances;

      // Instantiate the class properties.
      $this->first_name = $first_name;
      $this->last_name = $last_name;
      $this->street_address = $street_address;
      $this->city = $city;
      $this->state = $state;
      $this->zip = $zip;
    }

    // Define overriding clone.
    public function __clone()
    {
      // Set the instance counter and number instance.
      $this->instance = ++self::$instances;
    }

    // Define address getter.
    public function get_address()
    {
      // Declare and append values to return variable.
      $out  = $this->first_name." ".$this->last_name."<br>";
      $out .= $this->street_address."<br>";
      $out .= $this->city.", ".$this->state."  ".$this->zip."<br>";

      // Return address string.
      return $out;
    }

    // Define first name setter.
    public function set_first_name($first_name)
    {
      // Assign first name.
      $this->first_name = $first_name;
    }

    // Define how to convert the object to a string.
    public function __toString()
    {
      // Declare and append values to return variable.
      $out  = $this->first_name." ".$this->last_name.", ";
      $out .= $this->street_address.", ";
      $out .= $this->city.", ".$this->state."  ".$this->zip;

      // Return address string.
      return $out;
    }

    // Define a type hinting instance comparison function.
    public function equals(Address $obj)
    {  
      // Assign first name.
      if (($this->first_name == $obj->first_name) &&
           ($this->last_name == $obj->last_name) &&
            ($this->street_address == $obj->street_address) &&
             ($this->city == $obj->city) &&
              ($this->state == $obj->state) &&
               ($this->zip == $obj->zip))

        // They are equal.
        return true;

      else
      
        // They are unequal.
        return false;
    }
  }
?>
</body>
</html>
