<html>
<! BasicObject4.php                                           >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script declares and instantiate a class with the      >
<! default __construct() and __destruct functions and a       >
<! set_variables() static function.                           >
<head>
<title>
  Chapter 8 : BasicObject4.php
</title>
</head>
<body>
<?php
  // Reset the class instance variables.
  BasicObject::set_variables("Reset Private"
                            ,"Reset Protected"
                            ,"Reset Public");

  // Declare an object instance.
  $myObject = new BasicObject();

  // Print line break.
  print "<hr>";

  // Define a class that prints a message.
  class BasicObject
  {
    // Declare class variables.
    private static $myPrivate = "Privately Scoped Variable";
    protected static $myProtected = "Protected Scoped Variable";
    public static $myPublic = "Public Scoped Variable";

    public function __construct()
    {
      // Message on entrance.
      print "This is an [".__CLASS__."] instance.<br>";
      print "<hr>";
      print "Private Variable [".BasicObject::$myPrivate."]<br>";
      print "Protected Variable [".BasicObject::$myProtected."]<br>";
      print "Public Variable [".BasicObject::$myPublic."]<br>";
    }

    public function __destruct()
    {
      // Message on entrance.
      print "Private Variable [".BasicObject::$myPrivate."]<br>";
      print "Protected Variable [".BasicObject::$myProtected."]<br>";
      print "Public Variable [".BasicObject::$myPublic."]<br>";
    }

    public static function set_variables($private,$protected,$public)
    {
      BasicObject::$myPrivate = $private;
      BasicObject::$myProtected = $protected;
      BasicObject::$myPublic = $public;
    }
  }
?>
</body>
</html>
