<html>
<! Cloning.php                                                >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This declares, instantiate and clones a class.             >
<head>
<title>
  Chapter 8 : Cloning.php
</title>
</head>
<body>
<?php
  // Declare a variable to hold an object instance.
  $myAddress1 = new Address("Ian","McLaughlin"
                           ,"1111 Broadway","Oakland","CA","94601");

  // Print instance contents.
  print $myAddress1->get_address();

  // Insert paragraph return.
  print "<p>";

  // Clone a copy of an object.
  $myAddress2 = clone $myAddress1;

  // Update first name.
  $myAddress2->set_first_name("Elise");

  // Print instance contents.
  print $myAddress2->get_address();

  // Define a class that prints a message.
  class Address
  {
    // Declare instance counter.
    public static $instances = 0;

    // Declare instance number.
    private $instance;

    // Define instance variables.
    private $first_name = "";
    private $last_name = "";
    private $street_address = "";
    private $city = "";
    private $state = "";
    private $zip = "";

    // Define overriding constructor.
    public function __construct($first_name,$last_name
                               ,$street_address
                               ,$city,$state,$zip)
    {
      // Set the instance counter and number instance.
      $this->instance = ++self::$instances;

      // Instantiate the class properties.
      $this->first_name = $first_name;
      $this->last_name = $last_name;
      $this->street_address = $street_address;
      $this->city = $city;
      $this->state = $state;
      $this->zip = $zip;
    }

    public function __clone()
    {
      // Set the instance counter and number instance.
      $this->instance = ++self::$instances;
    }

    // Define address getter.
    public function get_address()
    {
      // Declare and append values to return variable.
      $out  = $this->first_name." ".$this->last_name."<br>";
      $out .= $this->street_address."<br>";
      $out .= $this->city.", ".$this->state."  ".$this->zip."<br>";

      // Return address string.
      return $out;
    }

    // Define first name setter.
    public function set_first_name($first_name)
    {
      // Assign first name.
      $this->first_name = $first_name;
    }
  }
?>
</body>
</html>
