<html>
<! Interface.php                                              >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script declares an interface, abstract class          >
<! implementing the interface, and class extending the        >
<! abstract class subclass.                                   >
<head>
<title>
  Chapter 8 : Interface.php
</title>
</head>
<body>
<?php
  // Define an interface.
  interface ClassInformation
  {
    // Define interface function.
    public function getClassName();
  }

  // Define an abstract class.
  abstract class PageWriter implements ClassInformation
  {
    // Define an abstract function specification.
    abstract function writePage($var);

    // Define a function
    public function getClassName()
    {
      // Return class name.
      return __CLASS__;
    }
  }

  // Define a concrete class.
  class PageHeader extends PageWriter
  {
    // Provide implementation of the abstract function.
    public function writePage($var)
    {
      // Print local class name and actual parameter.
      print "[".__CLASS__."] [".$var."]<br>";

      // Print parent class name and actual parameter.
      print "[".parent::getClassName()."] [Abstract Class!]<br>";
    }
  }

  // Declare a instance of the concrete class.
  $myObject = new PageHeader();

  // Call the concrete class instance.
  $myObject->writePage("Concrete Class!");
?>
</body>
</html>
