<html>
<! Reflection.php                                             >
<! Chapter 8, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to use the reflecct_class()   >
<! function to reflect, or see into an object definition.     >
<head>
<title>
  Chapter 8 : Reflection.php
</title>
</head>
<body>
<?php
  // Discover the OCI-Collection Object.
  print "<hr>".reflect_class('OCI-Collection')."<hr>";

  // Define an object reflector function.
  function reflect_class($object_name)
  {
    // Declare a global constant.
    define('INDENT',"&nbsp;&nbsp;");

    // Declare a reflection class base on input string.
    $class = new ReflectionClass($object_name);
    $class_str = $class->__toString();

    // Set control variables for do-while loop.
    $minus = true;
    $start = 0;

    // Strip dashes, which are reserved characters in preg_replace().
    do
    {
      if (strpos($class_str,'-',$start))
      {
        $class_str = substr_replace($class_str,""
                                   ,strpos($class_str,'-',$start),1);
        $start = strpos($class_str,'-',$start);
      }
      else
      {
        $minus = false;
      }
    } while ($minus);

    // Replace HTML characters with HTML macros.
    $class_str = htmlspecialchars($class_str);

    // Put the words and symbols into an array.
    $raw = explode(' ',$class_str);

    // Define an array for words and symbols.
    $words = array();

    // Eliminate non-rendered formatting.
    for ($i = 0;$i < count($raw);$i++)
    {
      if (strlen($raw[$i]) > 0)
      {
        $temp = "";

        // Capture a word character stream for rendered characters.
        for ($j = 0;$j < strlen($raw[$i]);$j++)
          if ((ord(substr($raw[$i],$j,1)) != 10) && // Tab            :\t
              (ord(substr($raw[$i],$j,1)) != 12) && // Line feed      :\n
              (ord(substr($raw[$i],$j,1)) != 15))   // Carriage return:\r
            $temp .= substr($raw[$i],$j,1);

        // Assign new word.
        $words[] = $temp;
      }
    }

    // Declare return string.
    $desc = "";

    // Declare indentation offset variable.
    $offset = 0;

    // Parse the array of words.
    for ($i = 0;$i < count($words);$i++)
    {
      switch(true)
      {
        // Append first word of word set to line.
        case ($i == 0):

          $desc .= $words[$i];
          break;

        // Treat terminal element as piggy-backed curly braces.
        case ((count($words) - 1) == $i):

          $desc .= substr($words[$i],0,1)."<br>\n".indent_str(--$offset);
          $desc .= substr($words[$i],-1,1)."<br>\n";
          break;

        // Prior not open and current close curly brace.
        case (($words[$i-1] != "{") && ($words[$i] == "}")):

          // Shave off the one indent set.
          $desc = substr($desc,0,strlen($desc) - strlen(INDENT));
          $desc .= $words[$i]."<br>\n".indent_str(--$offset);
          break;

        // Prior open and current close curly brace.
        case (($words[$i-1] == "{") && ($words[$i] == "}")):

          $desc .= $words[$i]."<br>\n".indent_str($offset);
          break;

        // Current open and next close curly brace.
        case (($words[$i] == "{") && ($words[$i+1] == "}")):

          $desc .= " ".$words[$i];
          break;

        // Current open and next not close curly brace.
        case (($words[$i] == "{") && ($words[$i+1] != "}")):

          $desc .= " ".$words[$i]."<br>\n".indent_str(++$offset);
          break;

        // Current close sqaure bracket and next Parameter or Property.
        case (($words[$i] == "]") && (substr($words[$i+1],0,1) == "P")):

          $desc .= " ".$words[$i]."<br>\n".indent_str($offset);
          break;

        // Current close square bracket and next closed curly brace.
        case (($words[$i] == "]") && ($words[$i+1] == "}")):

          $desc .= " ".$words[$i]."<br>\n".indent_str($offset);
          break;

        // Middle words.
        default:
        $desc .= " ".$words[$i];
        break;
      }
    }

    // Return reflected class.
    return $desc;
  }

  // Define indentation builder.
  function indent_str($offset)
  {
    $spacer = "";
    for ($j = 0;$j < $offset;$j++)
      $spacer .= INDENT;

    return $spacer;
  }
?>
</body>
</html>
