<html>
<! MyException.inc                                            >
<! Chapter 9, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This creates a subclass of the Exception class.            >
<head>
<title>
  Chapter 9 : MyException.inc
</title>
</head>
<body>
<?php
  // Define a subclass of Exception.
  class MyException extends Exception
  {
    // Define a backtrace class instance variable.
    protected $backtrace = "";

    // Define overriding constructor.
    public function __construct($e_msg,$e_code,$e_override)
    {
      if (is_string($e_msg))
        $this->message = $e_msg;
        
      if (is_int($e_code))
        $this->code = $e_code;
              
      if (is_string($e_override))
        $this->override = $e_override;
              
      // Get the error stack.
      $this->backtrace = debug_backtrace();
    }

    // Add a function to return the trace information.
    public function getBackTrace()
    {
      return $this->backtrace;
    }

    // Define how to convert the object to a string.
    public function __toString()
    {
      return $this->override;
    }
  }
?>
</body>
</html>
