<html>
<! TryCatchOverride.php                                       >
<! Chapter 9, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates mapping a runtime error to a      >
<! runtime exception, and uses a object type hint to catch    >
<! either a standard or user-defined exception.               >
<head>
<title>
  Chapter 9 : TryCatchOverride.php
</title>
</head>
<body>
<?php
  // Declare an Exception subclass file name.
  $override = "MyException.inc";

  // Declare a non-existant file name.
  $file = "User.inc";

  // Raise an error on a non-existent resource and re-throw an exception.
  try
  {
    if (@!include_once($override))
      throw new MyException("include_once($file) not found.",1,"Override");

    if (@!include_once($file))
      throw new MyException("include_once($file) not found.",1,"Override");
  }
  catch (MyException $e)
  {
    // Convert exception into an array.
    $error_detail = array();
    $error_detail["getCode()"] = $e->getCode();
    $error_detail["getMessage()"] = $e->getMessage();
    $error_detail["getFile()"] = $e->getFile();
    $error_detail["getLine()"] = $e->getLine();
    $error_detail["getTrace()"] = $e->getTrace();
    $error_detail["getBackTrace()"] = $e->getBackTrace();
    $error_detail["__toString()"] = $e->__toString();

    // Print rendered table.
    print render_table($error_detail);
  }
  catch (Exception $e)
  {
    // Convert exception into an array.
    $error_detail = array();
    $error_detail["getCode()"] = $e->getCode();
    $error_detail["getMessage()"] = $e->getMessage();
    $error_detail["getFile()"] = $e->getFile();
    $error_detail["getLine()"] = $e->getLine();
    $error_detail["__toString()"] = $e->__toString();

    // Print rendered table.
    print render_table($error_detail);
  }

  // A recursive program for rendering nested tables.
  function render_table($error_array)
  {
    // Declare variable with table start.
    $output = "<table border=0 cellpadding=0 cellspacing=0>";

    // Read and add array keys and values to a string.
    foreach ($error_array as $hashName => $hashValue)
    {
      // Append row tag and first column value.
      $output .= "<tr><td valign=top>[".$hashName."]</td>";

      // Check column value for nested array.
      if ((is_array($hashValue)) && (count($hashValue) > 0))
      {
        // Call recursively a copy of itself with cell tags.
        $output .= "<td>".render_table($hashValue)."</td></tr>";
      }
      else
      {
        // Append non-array value or white space for a zero element array.
        if (!is_array($hashValue))
          $output .= "<td>[".$hashValue."]</td></tr>";
        else
          $output .= "<td>[&nbsp;]</td></tr>";
      }
    }

    // Close HTML table.
    $output .= "</table>";

    // Return the HTML table.
    return $output;
  }
?>
</body>
</html>
