<html>
<! UserErrorHandler.inc                                       >
<! Chapter 9, Oracle Database XE PHP Web Programming          >
<! by Michael McLaughlin                                      >
<!                                                            >
<! This script demonstrates how to use a user-define error    >
<! handler.                                                   >
<head>
<title>
  Chapter 9 : UserErrorHandler.inc
</title>
</head>
<body>
<?php
  // Include a library class.
  include_once("UserErrorHandler.inc");

  // Set override error level and captures old level.
  $base = error_reporting(E_USER_ERROR | E_USER_WARNING | E_USER_NOTICE);

  // Set the user error handler.
  set_error_handler("user_error_handler");

  // Define a variable.
  $myVar;

  // Raise notice error when variable is not set.
  if (!isset($myVar))
    trigger_error("Variable is not set!",E_USER_NOTICE);

  // Restore the generic or prior error handler.
  restore_error_handler();

  // Reset the error reporting level.
  error_reporting($base);

  // Print current error reporting level.
  print "[".error_reporting()."]<br>";
?>
</body>
</html>
