CREATE OR REPLACE PACKAGE PKG_DBSEC_CUST_SALES_REP AS 
	PROCEDURE SET_CONTEXT;
END;
/


CREATE OR REPLACE PACKAGE BODY PKG_DBSEC_CUST_SALES_REP IS
	PROCEDURE SET_CONTEXT IS
	V_SALES NUMBER;
	BEGIN
		SELECT SALES_REP_ID
		INTO V_SALES
		FROM DBSEC.DBSEC_CUSTOMERS_APP_CONTEXT
		WHERE USER_NAME = USER;
		
		DBMS_SESSION.SET_CONTEXT('DBSEC_CUSTOMERS_SALESREP', 'SALES_REPID', V_SALES);
		END;
	END;
/


-- create an application context for this policy
CREATE OR REPLACE CONTEXT DBSEC_CUSTOMERS_SALESREP
	USING PKG_DBSEC_CUST_SALES_REP
/

--create a new vpd function policy to add a where clause predicate.
CREATE OR REPLACE FUNCTION
	DBSEC_CUST_SALESREP_WHERE(P_SCHEMA_NAME IN VARCHAR2,
				  P_OBJECT_NAME IN VARCHAR2) RETURN VARCHAR2 IS
	V_WHERE VARCHAR2(4000);
 BEGIN

	V_WHERE := 'SALES_REP_ID = ' || SYS_CONTEXT('DBSEC_CUSTOMERS_APP_CONTEXT', 'SALES_REPID');
		RETURN V_WHERE;
 END;
/

-- Add a VPD policy for the CUSTOMERS table

ExEC DBMS_RLS.ADD_POLICY(OBJECT_SCHEMA => 'DBSEC', -
			OBJECT_NAME    => 'CUSTOMERS', -		
			POLICY_NAME    => 'DBSEC_CUST_OWNER_POLICY', -
			FUNCTION_SCHEMA=> 'DBSEC', -
			POLICY_FUNCTION=> 'DBSEC_CUST_OWNER_WHERE', -
			STATEMENT_TYPES=> 'SELECT, UPDATE, INSERT, DELETE', -
			ENABLE         =>  TRUE)
-- Create an after-logon trigger to set the application context:

CREATE OR REPLACE TRIGGER TRG_AFTER_LOGON
AFTER LOGON
ON DATABASE
BEGIN
	PKG_DBSEC_CUST_SALES_REP.SET_CONTEXT;
END;
/