CREATE OR REPLACE PACKAGE PKG_SALES AS 
	PROCEDURE SET_CONTEXT;
END;
/


CREATE OR REPLACE PACKAGE BODY PKG_SALES IS
	PROCEDURE SET_CONTEXT IS
	V_SALES NUMBER;
	BEGIN
		SELECT SALES_REP_ID
		INTO V_SALES
		FROM DBSEC.DBSEC_CUSTOMERS_APP_CONTEXT
		WHERE USER_NAME = USER;
		
		DBMS_SESSION.SET_CONTEXT('SALESREP', 'SALES_REPID', V_SALES);
		END;
	END;
/

CREATE OR REPLACE CONTEXT SALESREP
	USING PKG_SALES
/

CREATE OR REPLACE TRIGGER TRG_LOGON
AFTER LOGON
ON DATABASE
BEGIN
	PKG_SALES.SET_CONTEXT;
END;
/