-- dropping of table if already exists
DROP TABLE APP_AUDIT_ENTITY CASCADE CONSTRAINTS;
DROP TABLE APP_AUDIT_ACTION_TYPE CASCADE CONSTRAINTS;
DROP TABLE APP_AUDIT_ACTION CASCADE CONSTRAINTS;
DROP TABLE APP_AUDIT_DATA CASCADE CONSTRAINTS;

-- dropping application tables
DROP TABLE APP_TBL1 CASCADE CONSTRAINTS;
DROP TABLE APP_TBL2 CASCADE CONSTRAINTS;

-- dropping the sequence
DROP SEQUENCE SEQ_APP_AUDIT_DATA;

-- creation of APP_AUDIT_ENTITY table
CREATE TABLE APP_AUDIT_ENTITY (
	ENTITY_ID 	NUMBER NULL,
	ENTITY_NAME	VARCHAR2(30) NULL,
	ENTITY_TYPE	VARCHAR2(15) NULL,
	CTL_REC_STAT	VARCHAR2(1)  NULL,
	PRIMARY KEY (ENTITY_ID)
);

CREATE TABLE APP_AUDIT_ACTION_TYPE (
	ACTION_TYPE_ID 		NUMBER NULL,
	ACTION_TYPE_DBSEC	VARCHAR2(30) NULL,
	CTL_REC_STAT		VARCHAR2(1)  NULL,
	PRIMARY KEY (ACTION_TYPE_ID)
);

CREATE TABLE APP_AUDIT_ACTION (
	AUDIT_ACTION_ID		NUMBER NULL,
	AUDIT_START_DATE	DATE   NULL,
	AUDIT_EXPIRE_DATE	DATE   NULL,
	CTL_INS_DTTM		DATE   NULL,
	CTL_UPD_DTTM		DATE   NULL,
	CTL_UPD_USER		VARCHAR2(30) NULL,
	CTL_REC_STAT		VARCHAR2(1)  NULL,
	ACTION_TYPE_ID		NUMBER NULL,
	ENTITY_ID		NUMBER NULL
	);

/* ALTER TABLE APP_AUDIT_ACTION
 ADD CONSTRAINT AUDIT_ACTION_ID PRIMARY KEY 
  (AUDIT_ACTION_ID) ;

ALTER TABLE APP_AUDIT_ACTION
 ADD CONSTRAINT AUDIT_ACTION_ID_FK
 FOREIGN KEY 
  (ENTITY_ID)
 REFERENCES APP_AUDIT_ENTITY
  (ENTITY_ID);

ALTER TABLE APP_AUDIT_ACTION
 ADD CONSTRAINT ACTION_TYPE_ID_FK
 FOREIGN KEY 
  (ACTION_TYPE_ID)
 REFERENCES APP_AUDIT_ACTION_TYPE
  (ACTION_TYPE_ID); 
*/

CREATE TABLE APP_AUDIT_DATA (
	AUDIT_DATA_ID		NUMBER NULL,
	AUDIT_DATA		VARCHAR2 (4000) NULL,
	AUDIT_ACTION_ID		NUMBER NULL,
	AUD_INS_DTTM		DATE  NULL,
	AUD_UPD_USER		VARCHAR2(30) NULL,
	AUD_REC_STAT		VARCHAR2(1) NULL
	);

/* ALTER TABLE APP_AUDIT_DATA
 ADD CONSTRAINT AUDIT_DATA_ID PRIMARY KEY 
  (AUDIT_ACTION_ID);	

ALTER TABLE APP_AUDIT_DATA
 ADD CONSTRAINT ACTION_TYPE_ID
 FOREIGN KEY 
  (AUDIT_ACTION_ID)
 REFERENCES APP_AUDIT_ACTION
  (AUDIT_ACTION_ID);

*/

-- we need to create a sequence object for the AUDIT_DATA_ID column
CREATE SEQUENCE SEQ_APP_AUDIT_DATA
	INCREMENT BY 1
	START WITH 1
	MINVALUE 1
	NOCYCLE
	CACHE 20
	NOORDER;

-- next, we build two table for applications
CREATE TABLE APP_TBL1(
	CODE	NUMBER PRIMARY KEY,
	DESCRIPTION	VARCHAR2(20)
  );

CREATE TABLE APP_TBL2(
	ID	NUMBER PRIMARY KEY,
	NAME	VARCHAR2(35),
	PHONE	VARCHAR2(14)
   );

-- inserting value in to application tables
INSERT INTO APP_TBL1(CODE,DESCRIPTION) VALUES (1,'Description # 1');

INSERT INTO APP_TBL1(CODE,DESCRIPTION) VALUES (2,'Description # 2');

INSERT INTO APP_TBL2(ID, NAME, PHONE) VALUES(100, 'Tom Jones', '123-123-1234');

INSERT INTO APP_TBL2(ID, NAME, PHONE) VALUES(101, 'Linda Evans', '234-234-2345');

INSERT INTO APP_TBL2(ID, NAME, PHONE) VALUES(102, 'Joan collins', '345-345-3456');


-- inserting values in to auditing repository wiht metadata
INSERT INTO APP_AUDIT_ACTION_TYPE (ACTION_TYPE_ID, ACTION_TYPE_DBSEC, CTL_REC_STAT)
			VALUES (1, 'UPDATE', 'A');

INSERT INTO APP_AUDIT_ACTION_TYPE (ACTION_TYPE_ID, ACTION_TYPE_DBSEC, CTL_REC_STAT)
			VALUES (2, 'DELETE', 'A');

INSERT INTO APP_AUDIT_ACTION_TYPE (ACTION_TYPE_ID, ACTION_TYPE_DBSEC, CTL_REC_STAT)
			VALUES (3, 'INSERT', 'A');


INSERT INTO APP_AUDIT_ENTITY (ENTITY_ID, ENTITY_NAME, ENTITY_TYPE, CTL_REC_STAT)
			VALUES(1,'DBSEC', 'USER','A');

INSERT INTO APP_AUDIT_ENTITY (ENTITY_ID, ENTITY_NAME, ENTITY_TYPE, CTL_REC_STAT)
			VALUES(2,'APP_TBL2', 'TABLE','A');

INSERT INTO APP_AUDIT_ENTITY (ENTITY_ID, ENTITY_NAME, ENTITY_TYPE, CTL_REC_STAT)
			VALUES(3,'APP_TBL1', 'TABLE','A');



INSERT INTO APP_AUDIT_ACTION (AUDIT_ACTION_ID, AUDIT_START_DATE, AUDIT_EXPIRE_DATE,
			CTL_INS_DTTM, CTL_UPD_DTTM, CTL_UPD_USER, CTL_REC_STAT,
			ACTION_TYPE_ID, ENTITY_ID)
		VALUES (1, sysdate,sysdate+30, sysdate,sysdate,
			   'DBSEC', 'A', 1,1);

		
INSERT INTO APP_AUDIT_ACTION (AUDIT_ACTION_ID, AUDIT_START_DATE, AUDIT_EXPIRE_DATE,
			CTL_INS_DTTM, CTL_UPD_DTTM, CTL_UPD_USER, CTL_REC_STAT,
			ACTION_TYPE_ID, ENTITY_ID)
		VALUES (2, sysdate,sysdate+30, sysdate,sysdate,'DBSEC', 'A', 2,3);	

COMMIT;

-- Now we need to create the stored package used with the trigger.
CREATE OR REPLACE PACKAGE pkg_App_Audit IS
	
	PROCEDURE INSERT_DATA(
				P_TABLE_NAME VARCHAR2,
				P_OPERATION  VARCHAR2
	);

	FUNCTION AUDIT_CHECK (
				P_USER_NAME  VARCHAR2,
				P_TABLE_NAME VARCHAR2,
				P_OPERATION  VARCHAR2) RETURN NUMBER;
	END;
/


-- Now we create body of the package
CREATE OR REPLACE PACKAGE BODY pkg_App_Audit IS
	
-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--  FUNCTION CHECKS IF TABLE IS AUDITED.
-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	FUNCTION AUDIT_CHECK (
				P_USER_NAME  VARCHAR2,
				P_TABLE_NAME VARCHAR2,
				P_OPERATION  VARCHAR2) RETURN NUMBER IS

	V_ID  NUMBER := 0;
   BEGIN
	BEGIN
		SELECT A.AUDIT_ACTION_ID
		INTO V_ID
		FROM APP_AUDIT_ENTITY E,
		     APP_AUDIT_ACTION A,
		     APP_AUDIT_ACTION_TYPE T
		WHERE A.ACTION_TYPE_ID=T.ACTION_TYPE_ID
		   AND A.ENTITY_ID = E.ENTITY_ID
		   AND E.ENTITY_NAME = P_USER_NAME
		   AND E.ENTITY_TYPE = 'USER'
		   AND T.ACTION_TYPE_DBSEC = UPPER(P_OPERATION)
		   AND SYSDATE BETWEEN AUDIT_START_DATE AND AUDIT_EXPIRE_DATE;

	EXCEPTION WHEN OTHERS THEN
		RETURN NULL;
		END;
	IF V_ID IS NULL THEN
	
	BEGIN
		SELECT A.AUDIT_ACTION_ID
		INTO V_ID
		FROM APP_AUDIT_ENTITY E,
		     APP_AUDIT_ACTION A,
		     APP_AUDIT_ACTION_TYPE T
		WHERE A.ACTION_TYPE_ID=T.ACTION_TYPE_ID
		   AND A.ENTITY_ID = E.ENTITY_ID
		   AND E.ENTITY_NAME = P_USER_NAME
		   AND E.ENTITY_TYPE = 'TABLE'
		   AND T.ACTION_TYPE_DBSEC = UPPER(P_OPERATION)
		   AND SYSDATE BETWEEN AUDIT_START_DATE AND AUDIT_EXPIRE_DATE;

	EXCEPTION WHEN OTHERS THEN
		RETURN NULL;
		END;
	END IF;


	RETURN V_ID;
	END;
-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--    INSERT OLD VALUES INTO AUDIT TABLE
-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

PROCEDURE INSERT_DATA(
			P_TABLE_NAME VARCHAR2,
			P_OPERATION VARCHAR2
		      ) IS
	V_IDS NUMBER;
     BEGIN
 V_IDS := AUDIT_CHECK(USER, P_TABLE_NAME, P_OPERATION);

    IF V_IDS IS NULL THEN
	RETURN;
     END IF;
		INSERT INTO INFO(USER_ID,USER_TABLE,USER_PER)
				VALUES(USER,P_TABLE_NAME, P_OPERATION);


 INSERT INTO APP_AUDIT_DATA(AUDIT_DATA_ID, AUDIT_DATA, AUDIT_ACTION_ID,
					AUD_INS_DTTM, AUD_UPD_USER, AUD_REC_STAT)
				VALUES(SEQ_APP_AUDIT_DATA.NEXTVAL, P_OPERATION, V_IDS,
					SYSDATE, USER, 'A');
	END;
-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


   END;
/

-- Now we nee to create trigger for APP_TBL1 and APP_TBL2

CREATE OR REPLACE TRIGGER TRG_APP_TBL1_BUDIR
	BEFORE UPDATE OR DELETE OR INSERT ON APP_TBL1
	FOR EACH ROW

    DECLARE
	V_OPERATION VARCHAR2(20);

    BEGIN
	DBMS_OUTPUT.PUT_LINE(' TRIGGER FIRED FOR APP_TBL1--1');
	IF INSERTING THEN
	    V_OPERATION := 'INSERT';
	ELSIF UPDATING THEN
	    V_OPERATION := 'UPDATE';
	ELSE
	    V_OPERATION := 'DELETE';
	END IF;
	   DBMS_OUTPUT.PUT_LINE(' TRIGGER FIRED FOR APP_TBL1--2');

pkg_App_Audit.INSERT_DATA('APP_TABL1', V_OPERATION);
	DBMS_OUTPUT.PUT_LINE(' TRIGGER FIRED FOR APP_TBL1-------3');

   END;
/

CREATE OR REPLACE TRIGGER TRG_APP_TBL2_BUDIR
	BEFORE UPDATE OR DELETE OR INSERT ON APP_TBL2
	FOR EACH ROW

    DECLARE
	V_OPERATION VARCHAR2(20);

    BEGIN

	IF INSERTING THEN
	    V_OPERATION := 'INSERT';
	ELSIF UPDATING THEN
	    V_OPERATION := 'UPDATE';
	ELSE
	    V_OPERATION := 'DELETE';
	END IF;

	pkg_App_Audit.INSERT_DATA('APP_TABL2', V_OPERATION);

   END;
/

-- Now we r ready to test. We will be updating and inserting into APP_TBL1 and APP_TBL2

UPDATE APP_TBL1 SET
	DESCRIPTION = 'NEW DESCRIPTION #1'
	WHERE CODE =1
/

INSERT INTO APP_TBL1
	VALUES(3, 'DESCRIPTION #3')
/

UPDATE APP_TBL2 SET
	PHONE = '567-567-5678'
	WHERE ID =100;


DELETE APP_TBL2
	WHERE ID=102
/

COMMIT;


-- Now  check the APP_AUDIT_DATA
column AUDIT_DATA format a10;     
-- column AUDIT_ACTION_ID format 99999;       
column AUD_INS_DTTM  format a10;         
column AUD_UPD_USER  format a10;         
column AUD_REC_STAT format a10;          


SELECT * FROM APP_AUDIT_DATA
/
