
-- dropping DEPARTMENTS table if already exist
DROP TABLE DEPARTMENTS CASCADE CONSTRAINTS;

-- dropping APP_AUDIT_DATA table if already exist
DROP TABLE APP_AUDIT_DATA CASCADE CONSTRAINTS;

-- creating DEPARTMENTS table.
CREATE TABLE DEPARTMENTS
  (
	DEPARTMENT_ID NUMBER(2) PRIMARY KEY,
	DEPARTMENT_NAME VARCHAR2(20),
	CITY            VARCHAR2(30),
	STATE           CHAR(2)
  );

CREATE TABLE APP_AUDIT_DATA
  (
	AUDIT_DATA_ID NUMBER PRIMARY KEY,
        AUDIT_OBJECT  VARCHAR2(30),
        AUDIT_OPERATION VARCHAR2(20),
        AUD_INS_DTTM    DATE,
        AUD_UPD_USER    VARCHAR2(30),
        AUD_REC_STAT    VARCHAR2(1)
   );

-- create a sequence object used for the AUDIT_DATA_ID column
-- of the APP_AUDIT_DATA table. Sequence will generate unique values

CREATE SEQUENCE SEQ_APP_AUDIT_DATA
	INCREMENT BY 1
        START WITH 1
        MINVALUE 1
        NOCYCLE
        CACHE 20
        NOORDER;


-- creating the trigger on the DEPARTMENTS table that will record the DML operations

CREATE OR REPLACE TRIGGER TRG_DEPARTMENT_AIUD
     AFTER INSERT OR UPDATE OR DELETE
     ON DEPARTMENTS
  DECLARE

	V_OPR VARCHAR2(20);
  BEGIN
	IF INSERTING THEN
		V_OPR := 'INSERT';
	ELSIF UPDATING THEN
		V_OPR := 'UPDATE';
	ELSE
		V_OPR := 'DELETE';
	END IF;

	INSERT INTO APP_AUDIT_DATA (
					AUDIT_DATA_ID,
					AUDIT_OBJECT,
					AUDIT_OPERATION,
					AUD_INS_DTTM,
					AUD_UPD_USER,    
					AUD_REC_STAT
					) VALUES
					( SEQ_APP_AUDIT_DATA.NEXTVAL,
					  'DEPARTMENTS',
					  V_OPR,
					  SYSDATE,
					  USER,
					  'A'
					);

   EXCEPTION WHEN OTHERS THEN
   
   NULL;

 END;
/

-- inserting new value into the DEPARTMENTS table

INSERT INTO DEPARTMENTS ( DEPARTMENT_ID, DEPARTMENT_NAME, CITY,STATE)
		VALUES  ( 10, 'Accounting', 'Boston', 'NY');

INSERT INTO DEPARTMENTS ( DEPARTMENT_ID, DEPARTMENT_NAME, CITY,STATE)
		VALUES  ( 11, 'Proudction', 'Redlands', 'CA');

COMMIT;


-- updating DEPARTMENTS table
UPDATE DEPARTMENTS SET
		CITY = 'Dallas',
		STATE= 'TX'
	WHERE DEPARTMENT_ID =10;

COMMIT;

-- deleting a row from DEPARTMENTS table
DELETE FROM DEPARTMENTS
	WHERE DEPARTMENT_ID = 11;

COMMIT;


-- To view the contents of the auditing table APP_AUDIT_DATA
SELECT AUDIT_DATA_ID ID,
       AUDIT_OBJECT TABLE_NAME,
       AUDIT_OPERATION OPERATION,
       TO_CHAR(AUD_INS_DTTM, 'DD-MON-YYYY HH24:MI:SS') CREATE_DATE,
       AUD_UPD_USER USERNAME,
       AUD_REC_STAT ROW_STATUS
       FROM APP_AUDIT_DATA
 /
