-- DBMS_FGA procedure 

-- dropping procedure if they already exist
EXEC DBMS_FGA.DROP_POLICY(OBJECT_SCHEMA      => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_1_SELECT')

EXEC DBMS_FGA.DROP_POLICY(OBJECT_SCHEMA      => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_2_CREDIT')

EXEC DBMS_FGA.DROP_POLICY(OBJECT_SCHEMA      => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_3_DELETE')


-- procedure for select
EXEC DBMS_FGA.ADD_POLICY(OBJECT_SCHEMA       => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_1_SELECT', -
                         AUDIT_CONDITION     =>  NULL, -
			 AUDIT_COLUMN        =>  NULL, -
                         HANDLER_SCHEMA      =>  NULL, -
                         HANDLER_MODULE      =>  NULL, -
                         ENABLE              =>  TRUE, -
                         STATEMENT_TYPES     => 'SELECT')


-- procedure for insert and update
EXEC DBMS_FGA.ADD_POLICY(OBJECT_SCHEMA       => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_2_CREDIT', -
                         AUDIT_CONDITION     => 'CREDIT_LIMIT >= 10000', -
			 AUDIT_COLUMN        =>  NULL, -
                         HANDLER_SCHEMA      =>  NULL, -
                         HANDLER_MODULE      =>  NULL, -
                         ENABLE              =>  TRUE, -
                         STATEMENT_TYPES     => 'SELECT,INSERT,UPDATE')

-- procedure for delete
EXEC DBMS_FGA.ADD_POLICY(OBJECT_SCHEMA       => 'DBSEC', -
                         OBJECT_NAME         => 'CUSTOMERS', -
                         POLICY_NAME         => 'AUDIT_POLICY_3_DELETE', -
                         AUDIT_CONDITION     =>  NULL, -
			 AUDIT_COLUMN        =>  NULL, -
                         HANDLER_SCHEMA      =>  NULL, -
                         HANDLER_MODULE      =>  NULL, -
                         ENABLE              =>  TRUE, -
                         STATEMENT_TYPES     => 'DELETE')

-- table USER_AUDIT_POLICIES to view auditing policies that we own
SELECT OBJECT_NAME,
       POLICY_NAME,
       POLICY_TEXT,
       SEL, INS, UPD, DEL
FROM   USER_AUDIT_POLICIES;
